/*#include <iostream>

using namespace std; */



typedef long long ll;

int n;
ll mod = 1e9+7;

int abs(int x)
{
    return (x < 0) ? -x : x;
}

int pov(int x)
{
    return (x+3)%n + 1;
}

int dist(int a, int b)
{
    if(a > b) return n - (a - b - 1) - 2;
    return (b - a -1);
}

bool uIntervalu(int i, int l, int d)
{
    if(l < d) return l <= i && i <= d;
    else return !uIntervalu(i, (l == 1) ? n : l-1, d%n+1);
}

int brNacina[501][501] = {{0}};

void calcBrNacina(int *a)
{
    for(int len = 4; len <= n; len += 4)
    {
        for(int l = 2; l+len-1 <= n; l++)
        {
            int d = l+len-1;
            if(len == 4)
                brNacina[l][d] = ((a[l] + a[l+1] + a[l+2] + a[l+3]) % 2 == 1);
            else
            {
                brNacina[l][d] = 0;
                // poslednja cetvorka sama
                brNacina[l][d] += brNacina[l][d - (len-4)] * brNacina[d - (len-4) + 1][d];
                // prva cetvorka sama
                if(len != 8) brNacina[l][d] += brNacina[l+(len-4)][d] * brNacina[l][l + (len-4) - 1];

                // duplo uracunate kad su obe same
                if(len != 8) brNacina[l][d] -= brNacina[l+4][d-4];

                // 2-2
                brNacina[l][d] += brNacina[l+2][d-2] * ((a[l] + a[l+1] + a[d-1] + a[d]) % 2 == 1);
                // prvi i tri poslednja
                brNacina[l][d] += brNacina[l+1][d-3] * ((a[l] + a[d-2] + a[d-1] + a[d]) % 2 == 1);
                // tri prva i poslednji
                brNacina[l][d] += brNacina[l+3][d-1] * ((a[l] + a[l+1] + a[l+2] + a[d]) % 2 == 1);
            }
            //cout << "Za " << l << " " << d << " = " << brNacina[l][d] << endl;
        }
    }
}

int Zvezda(int nn, int *a)
{
    n = nn;
    calcBrNacina(a);
    if(n == 4) return (a[1] + a[2] + a[3] + a[4])%2 == 1;
    ll rez = 0;

    for(int i = 2; true; i = pov(i))
    {
        for(int j = i%n + 1; true; j = pov(j))
        {
            for(int k = j%n + 1; true; k = pov(k))
            {
                if((a[i] + a[j] + a[k] + a[1]) % 2 == 1)
                {
                    //cout << "Validna trojka " << 1 << " " << i << " " << j << " " << k << endl;
                    ll a1 = 1, a2 = 1, a3 = 1, a4 = 1;
                    if(abs(1 - i) != 1) a1 = brNacina[2][i-1];
                    if(abs(i - j) != 1) a2 = brNacina[i%n + 1][j-1];
                    if(abs(j - k) != 1) a3 = brNacina[j%n + 1][k-1];
                    if(k != n) a4 = brNacina[k%n + 1][n];

                    ll srez = rez;
                    rez += ((a1 * a2)%mod * (a3 * a4)%mod)%mod;
                    //cout << "Povecano za " << rez - srez << endl;
                }
                //else cout << "Nije validna " << 1 << " " << i << " " << j << " " << k << endl;
                if(pov(k) < k) break;
            }
            if(pov(j) < j) break;
        }
        if(pov(i) < i) break;
    }
    return rez%mod;
}

/*
int main()
{
    int n;
    cin >> n;
    int a[n];
    for(int i = 1; i <= n; i++) cin >> a[i];
    cout << Zvezda(n, a);
    return 0;
}
*/